<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

	if(!$admin_show['account_requests']) { show_error('Forbidden',403); }
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$count = 0;
?>
				<h1 class="administration">Administration</h1>
				<ul class="adminnav" role="menubar">
					<li role="presentation">
						<a href="/administration/account/requests" role="menuitem">Account Requests</a>
						<?PHP if($admin_show['application_requests'] || $admin_show['manage_accounts']) { ?>
						<ul role="menu">
							<?PHP if($admin_show['application_requests']) { ?>
								<li role="presentation"><a href="/administration/application/requests" role="menuitem">Application Requests</a></li>
							<?PHP } ?>
							<?PHP if($admin_show['manage_accounts']) { ?>
								<li role="presentation"><a href="/administration/manage/accounts" role="menuitem">Manage Accounts</a></li>
							<?PHP } ?>
							<?PHP if($admin_show['manage_groups']) { ?>
								<li role="presentation"><a href="/administration/manage/groups" role="menuitem">Manage Groups</a></li>
							<?PHP } ?>
							<?PHP if($admin_show['manage_facilities']) { ?>
								<li role="menuitem"><a href="/administration/manage/facilities">Manage Facilities</a></li>
							<?PHP } ?>
						</ul>
						<?PHP } ?>
					</li>
				</ul>
				<script type="text/javascript" src="/js/adminmenu.js"></script>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<script>
						$(function() {
							$("#tabs").tabs();
							$("[id^=dialog-form]").dialog({
								autoOpen: false,
								width: 600,
								height: 300,
								modal: true,
								buttons: {
									Submit: function(){
										var id = $(this).attr('id').replace('dialog-form','');
										$('#denyAccountForm'+id).submit();
									},
									Cancel: function(){
										$(this).dialog("close");
									}
								}
							});
							$("[id^=deny-account]").click(function(e) {
								var id = 0;
								if($(e.target).attr('id')){
									id = $(e.target).attr('id').replace('deny-account',''); 
								}
								else{
									id = $(e.target).parent().attr('id').replace('deny-account',''); //get parent id since click is on image
								}
								$("#dialog-form"+id).dialog("open");
							});
						});
					</script>
					<div id="tabs" class="column">
						<ul>
							<li><a id="pending_link" href="#pending" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Pending Approval</a></li>
							<li><a id="approved_link" href="#approved" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Approved</a></li>
							<li><a id="denied_link" href="#denied" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Denied</a></li>
						</ul>
						<?PHP 
							$request_lists = array('pending'=>$pending_list,'approved'=>$approved_list,'denied'=>$denied_list);
							foreach($request_lists as $id => $cur_request_list) {
								if (sizeof($cur_request_list) == 0) {
						?>
							<div id="<?PHP echo $id; ?>" >
								<?PHP if($id === 'pending') { ?>
									<p>This table lists account requests that are awaiting approval for access to the API services.</p>
								<?PHP } ?>
								<?PHP if($id === 'approved') { ?>
									<p>This table lists the account requests that have been approved for access to the API services.</p>
								<?PHP } ?>
								<?PHP if($id === 'denied') { ?>
									<p>This table lists the account requests that have been denied access to the API services.</p>
								<?PHP } ?>
								<div class="message">
									<?PHP if($id === 'pending') { ?>
										There are no account requests that are awaiting approval for access to the API services.
									<?PHP } ?>
									<?PHP if($id === 'approved') { ?>
										There are no account requests that have been approved for access to the API services.
									<?PHP } ?>
									<?PHP if($id === 'denied') { ?>
										There are no account requests that have been denied access to the API services.
									<?PHP } ?>
								</div>
							</div>
						<?php } else {?>
						<div id="<?PHP echo $id; ?>">
							<?PHP if($id === 'pending') { ?>
								<p>This table lists account requests that are awaiting approval for access to the API services.</p>
							<?PHP } ?>
							<?PHP if($id === 'approved') { ?>
								<p>This table lists the account requests that have been approved for access to the API services.</p>
							<?PHP } ?>
							<?PHP if($id === 'denied') { ?>
								<p>This table lists the account requests that have been denied access to the API services.</p>
							<?PHP } ?>
							<?PHP 
								echo form_open('/administration/account/requests',array('id'=>'account_request_list_form'));
								$hidden_inputs = array(
													'page_select_correction' => '',
													'prefix' => '',
													'pending_page_on_bar' => '',
													'pending_page_select' => '',
													'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
													'approved_page_on_bar' => '',
													'approved_page_select' => '',
													'approved_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
													'denied_page_on_bar' => '',
													'denied_page_select' => '',
													'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
												);
								echo form_hidden($hidden_inputs,TRUE);
								if($id === 'pending') {
									echo $pending_pages->display_pagination_bar();
								}
								if($id === 'approved') { 
									echo $approved_pages->display_pagination_bar();
								} 
								if($id === 'denied') {
									echo $denied_pages->display_pagination_bar();
								}
								echo form_close(); 
							?>
							<table class="display">
								<tr>
									<th>User</th>
									<th>Contact</th>
									<th>Requested Date</th>
									<?PHP if($id === 'pending') { ?><th class="displaylast">Actions</th> <?PHP } ?>
									<?PHP if($id === 'approved') { ?><th class="displaylast">Approved Date</th> <?PHP } ?>
									<?PHP if($id === 'denied') { ?><th class="displaylast">Justification</th> <?PHP } ?>
								</tr>
								<?php foreach($cur_request_list as $request) { ?>
									<tr id="<?php echo $request->id; ?>row">
										<td>
											<?php 
												if($request->middle_name) { echo $request->first_name.' '.$request->middle_name.' '.$request->last_name; }
												else { echo $request->first_name.' '.$request->last_name; }
												if($request->title) { echo '<br />'.$request->title; }
												if($request->department) { echo '<br />'. $request->department; }
												if($request->organization) { echo '<br />'. $request->organization; }
												if($request->user_org_id) { echo '<br />ID: '. $request->user_org_id; }
											?>
										</td>
										<td>
											<?php 
												if($request->ext_mail) { echo '<a href="mailto:"'.$request->ext_mail.'>'.$request->ext_mail.'</a>'; } 
												if($request->telephone) { echo '<br />Phone: '.$request->telephone; }
												if($request->mobile) { echo '<br />Mobile: '.$request->mobile; }
												if($request->location) { echo '<br />'. $request->location; }
											?>
										</td>
										<td><?php echo date("M d Y H:i:s",$request->request_date); ?>&nbsp;</td>
										<td>
											<?PHP if($id === 'pending') { ?>
											<?PHP
												echo form_open('/administration/approve_account_request',array('id'=>'approveAccountForm'.$request->id,'class'=>'approveAccountForm'));
												$hidden_inputs = array(
													'request_id' => $request->id,
													'pending_page_select_from_approve_button' => $pending_cur_page,
													'pending_items_per_page_from_approve_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'approved_page_select_from_approve_button' => $approved_cur_page,
													'approved_items_per_page_from_approve_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'denied_page_select_from_approve_button' => $denied_cur_page,
													'denied_items_per_page_from_approve_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
												);
												echo form_hidden($hidden_inputs,TRUE);
												echo form_close(); 
											?>
											
											<div id="dialog-form<?php echo $request->id; ?>" title="Reason for Denial">
											<?PHP
												echo form_open('/administration/deny_account_request',array('id'=>'denyAccountForm'.$request->id,'class'=>'denyAccountForm'));
												$hidden_inputs = array(
													'request_id' => $request->id,
													'pending_page_select_from_deny_button' => $pending_cur_page,
													'pending_items_per_page_from_deny_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'approved_page_select_from_deny_button' => $approved_cur_page,
													'approved_items_per_page_from_deny_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													'denied_page_select_from_deny_button' => $denied_cur_page,
													'denied_items_per_page_from_deny_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
												);
												echo form_hidden($hidden_inputs,TRUE);
												echo form_label('Reason for Denial:','denial_reason'.$request->id);
												echo form_textarea('reason','','id="denial_reason'.$request->id.'" class="modal"');
												echo form_close();
											?>

											</div>
											<div class="center">
												<a href="#" onclick="if ( confirm('Are you sure you want to approve the account for <?php echo $request->last_name.", ".$request->first_name; ?>?')){ this.parentNode.getElementsByTagName('a')[1].outerHTML = this.parentNode.getElementsByTagName('a')[1].innerHTML; this.outerHTML = this.innerHTML; $('#approveAccountForm<?php echo $request->id ?>').submit();}" title="Approve Request: <?php echo $request->first_name .' '.$request->last_name; ?>"><img src="/images/icons/accept.png" alt="Approve Request:  <?php echo $request->first_name .' '.$request->last_name; ?>" /></a>
												<a href="#" id="deny-account<?php echo $request->id; ?>" title="Deny Request: <?php echo $request->first_name .' '.$request->last_name; ?>"><img src="/images/icons/cancel.png" alt="Deny Request: <?php echo $request->first_name .' '.$request->last_name; ?>" /></a>
											</div>
											<?PHP } ?>
											<?PHP if($id === 'approved') {  echo date("M d Y H:i:s",$request->approved_date); } ?>
											<?PHP if($id === 'denied') { echo $request->justification; } ?>
										</td>
									</tr>
								<?php $count++; } ?>
							</table>
							<?PHP 
							echo form_open('/administration/account/requests',array('id'=>'account_request_list_form'));
								if($id === 'pending') { echo $pending_pages->display_pagination_bar(); }
								if($id === 'approved') { echo $approved_pages->display_pagination_bar(); }
								if($id === 'denied') { echo $denied_pages->display_pagination_bar(); }
								echo form_close(); 
							?>
						</div>
						<?PHP }} ?>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);
</script>